<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

abstract class XenCentral_AdServer_Locations_Hooks_Abstract_Post extends XenCentral_AdServer_Locations_Hooks_Abstract
{
    protected $first_post_only;

    protected $post_order;

    protected $node_id_list;

    protected $thread_id_list;

    protected $post_id_list;

    protected $user_id_list;

    public function getOptionTemplate()
    {
        return 'xcas_location_post_hook';
    }

    public function prepareFromData($locationData)
    {
        $locationData = parent::prepareFromData($locationData);

        if (!empty($locationData['first_post_only'])) {
            $this->first_post_only = $locationData['first_post_only'];
        }
        if (!empty($locationData['post_order'])) {
            $this->post_order = $locationData['post_order'];
        }
        if (!empty($locationData['node_id_list'])) {
            $this->node_id_list = $locationData['node_id_list'];
        }
        if (!empty($locationData['thread_id_list'])) {
            $this->thread_id_list = $locationData['thread_id_list'];
        }
        if (!empty($locationData['post_id_list'])) {
            $this->post_id_list = $locationData['post_id_list'];
        }
        if (!empty($locationData['user_id_list'])) {
            $this->user_id_list = $locationData['user_id_list'];
        }

        return $locationData;
    }

    public function preCheck()
    {
        if (!parent::preCheck()) {
            return false;
        }
        if (empty($this->hook_params['post'])
            OR empty($this->hook_params['post']['post_id'])
        ) {
            // no post-specific check is possible, so if we have something specified, ad should not be shown
            return is_null($this->first_post_only)
            AND is_null($this->node_id_list)
            AND is_null($this->post_id_list)
            AND is_null($this->thread_id_list)
            AND is_null($this->post_order)
            AND is_null($this->user_id_list);
        }

        if ($this->first_post_only AND $this->hook_params['post']['position'] != 0) {
            return false;
        }

        if($this->post_order) {
            $postOrders=explode(',', $this->post_order);
            $postOrders=array_map('trim', $postOrders);

            $matchFound=false;

            foreach($postOrders AS $postOrder) {
                if(strpos($postOrder, '%')===0) {
                    $postOrder=intval(trim($postOrder, '%'));
                    if($postOrder) {
                        if(
                            ($this->hook_params['post']['position'])%$postOrder===0
                        ) {
                            $matchFound=true;
                            break;
                        }
                    }
                } else {
                    if($this->hook_params['post']['position'] == $postOrder - 1) {
                        $matchFound=true;
                        break;
                    }
                }
            }

            if($matchFound==false) {
                return false;
            }
        }

        foreach (array(
                     'node_id_list' => 'node_id',
                     'thread_id_list' => 'thread_id',
                     'post_id_list' => 'post_id',
                     'user_id_list' => 'user_id'
                 ) AS $property => $value) {
            if ($this->$property AND !in_array($this->hook_params['post'][$value], explode(',', $this->$property))) {
                return false;
            }
        }

        return true;
    }


}